// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     content/common/permission_service.mojom
//

package org.chromium.mojom.content;

class PermissionService_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<PermissionService, PermissionService.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<PermissionService, PermissionService.Proxy>() {
    
        public String getName() {
            return "content::PermissionService";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, PermissionService impl) {
            return new Stub(core, impl);
        }
    
        public PermissionService[] buildArray(int size) {
          return new PermissionService[size];
        }
    };

    private static final int HAS_PERMISSION_ORDINAL = 0;
    private static final int REQUEST_PERMISSION_ORDINAL = 1;
    private static final int REQUEST_PERMISSIONS_ORDINAL = 2;
    private static final int REVOKE_PERMISSION_ORDINAL = 3;
    private static final int GET_NEXT_PERMISSION_CHANGE_ORDINAL = 4;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements PermissionService.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void hasPermission(int permission, String origin, HasPermissionResponse callback) {
            PermissionServiceHasPermissionParams _message = new PermissionServiceHasPermissionParams();
            _message.permission = permission;
            _message.origin = origin;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    HAS_PERMISSION_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PermissionServiceHasPermissionResponseParamsForwardToCallback(callback));
        }

        @Override
        public void requestPermission(int permission, String origin, boolean userGesture, RequestPermissionResponse callback) {
            PermissionServiceRequestPermissionParams _message = new PermissionServiceRequestPermissionParams();
            _message.permission = permission;
            _message.origin = origin;
            _message.userGesture = userGesture;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    REQUEST_PERMISSION_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PermissionServiceRequestPermissionResponseParamsForwardToCallback(callback));
        }

        @Override
        public void requestPermissions(int[] permission, String origin, boolean userGesture, RequestPermissionsResponse callback) {
            PermissionServiceRequestPermissionsParams _message = new PermissionServiceRequestPermissionsParams();
            _message.permission = permission;
            _message.origin = origin;
            _message.userGesture = userGesture;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    REQUEST_PERMISSIONS_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PermissionServiceRequestPermissionsResponseParamsForwardToCallback(callback));
        }

        @Override
        public void revokePermission(int permission, String origin, RevokePermissionResponse callback) {
            PermissionServiceRevokePermissionParams _message = new PermissionServiceRevokePermissionParams();
            _message.permission = permission;
            _message.origin = origin;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    REVOKE_PERMISSION_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PermissionServiceRevokePermissionResponseParamsForwardToCallback(callback));
        }

        @Override
        public void getNextPermissionChange(int permission, String origin, int lastKnownStatus, GetNextPermissionChangeResponse callback) {
            PermissionServiceGetNextPermissionChangeParams _message = new PermissionServiceGetNextPermissionChangeParams();
            _message.permission = permission;
            _message.origin = origin;
            _message.lastKnownStatus = lastKnownStatus;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    GET_NEXT_PERMISSION_CHANGE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PermissionServiceGetNextPermissionChangeResponseParamsForwardToCallback(callback));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<PermissionService> {

        Stub(org.chromium.mojo.system.Core core, PermissionService impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                PermissionService_Internal.MANAGER, messageWithHeader);
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), PermissionService_Internal.MANAGER, messageWithHeader, receiver);
                    case HAS_PERMISSION_ORDINAL: {
                        PermissionServiceHasPermissionParams data =
                                PermissionServiceHasPermissionParams.deserialize(messageWithHeader.getPayload());
                        getImpl().hasPermission(data.permission, data.origin, new PermissionServiceHasPermissionResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case REQUEST_PERMISSION_ORDINAL: {
                        PermissionServiceRequestPermissionParams data =
                                PermissionServiceRequestPermissionParams.deserialize(messageWithHeader.getPayload());
                        getImpl().requestPermission(data.permission, data.origin, data.userGesture, new PermissionServiceRequestPermissionResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case REQUEST_PERMISSIONS_ORDINAL: {
                        PermissionServiceRequestPermissionsParams data =
                                PermissionServiceRequestPermissionsParams.deserialize(messageWithHeader.getPayload());
                        getImpl().requestPermissions(data.permission, data.origin, data.userGesture, new PermissionServiceRequestPermissionsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case REVOKE_PERMISSION_ORDINAL: {
                        PermissionServiceRevokePermissionParams data =
                                PermissionServiceRevokePermissionParams.deserialize(messageWithHeader.getPayload());
                        getImpl().revokePermission(data.permission, data.origin, new PermissionServiceRevokePermissionResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case GET_NEXT_PERMISSION_CHANGE_ORDINAL: {
                        PermissionServiceGetNextPermissionChangeParams data =
                                PermissionServiceGetNextPermissionChangeParams.deserialize(messageWithHeader.getPayload());
                        getImpl().getNextPermissionChange(data.permission, data.origin, data.lastKnownStatus, new PermissionServiceGetNextPermissionChangeResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class PermissionServiceHasPermissionParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int permission;
        public String origin;
    
        private PermissionServiceHasPermissionParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PermissionServiceHasPermissionParams() {
            this(0);
        }
    
        public static PermissionServiceHasPermissionParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PermissionServiceHasPermissionParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PermissionServiceHasPermissionParams result = new PermissionServiceHasPermissionParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.permission = decoder0.readInt(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.origin = decoder0.readString(16, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(permission, 8);
            encoder0.encode(origin, 16, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PermissionServiceHasPermissionParams other = (PermissionServiceHasPermissionParams) object;
            if (this.permission != other.permission)
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.origin, other.origin))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(permission);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(origin);
            return result;
        }
    }

    static final class PermissionServiceHasPermissionResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int status;
    
        private PermissionServiceHasPermissionResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PermissionServiceHasPermissionResponseParams() {
            this(0);
        }
    
        public static PermissionServiceHasPermissionResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PermissionServiceHasPermissionResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PermissionServiceHasPermissionResponseParams result = new PermissionServiceHasPermissionResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.status = decoder0.readInt(8);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(status, 8);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PermissionServiceHasPermissionResponseParams other = (PermissionServiceHasPermissionResponseParams) object;
            if (this.status != other.status)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(status);
            return result;
        }
    }

    static class PermissionServiceHasPermissionResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final PermissionService.HasPermissionResponse mCallback;

        PermissionServiceHasPermissionResponseParamsForwardToCallback(PermissionService.HasPermissionResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(HAS_PERMISSION_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                PermissionServiceHasPermissionResponseParams response = PermissionServiceHasPermissionResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.status);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PermissionServiceHasPermissionResponseParamsProxyToResponder implements PermissionService.HasPermissionResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PermissionServiceHasPermissionResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            PermissionServiceHasPermissionResponseParams _response = new PermissionServiceHasPermissionResponseParams();
            _response.status = status;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    HAS_PERMISSION_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class PermissionServiceRequestPermissionParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int permission;
        public String origin;
        public boolean userGesture;
    
        private PermissionServiceRequestPermissionParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PermissionServiceRequestPermissionParams() {
            this(0);
        }
    
        public static PermissionServiceRequestPermissionParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PermissionServiceRequestPermissionParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PermissionServiceRequestPermissionParams result = new PermissionServiceRequestPermissionParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.permission = decoder0.readInt(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.userGesture = decoder0.readBoolean(12, 0);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.origin = decoder0.readString(16, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(permission, 8);
            encoder0.encode(userGesture, 12, 0);
            encoder0.encode(origin, 16, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PermissionServiceRequestPermissionParams other = (PermissionServiceRequestPermissionParams) object;
            if (this.permission != other.permission)
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.origin, other.origin))
                return false;
            if (this.userGesture != other.userGesture)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(permission);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(origin);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(userGesture);
            return result;
        }
    }

    static final class PermissionServiceRequestPermissionResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int status;
    
        private PermissionServiceRequestPermissionResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PermissionServiceRequestPermissionResponseParams() {
            this(0);
        }
    
        public static PermissionServiceRequestPermissionResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PermissionServiceRequestPermissionResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PermissionServiceRequestPermissionResponseParams result = new PermissionServiceRequestPermissionResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.status = decoder0.readInt(8);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(status, 8);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PermissionServiceRequestPermissionResponseParams other = (PermissionServiceRequestPermissionResponseParams) object;
            if (this.status != other.status)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(status);
            return result;
        }
    }

    static class PermissionServiceRequestPermissionResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final PermissionService.RequestPermissionResponse mCallback;

        PermissionServiceRequestPermissionResponseParamsForwardToCallback(PermissionService.RequestPermissionResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(REQUEST_PERMISSION_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                PermissionServiceRequestPermissionResponseParams response = PermissionServiceRequestPermissionResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.status);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PermissionServiceRequestPermissionResponseParamsProxyToResponder implements PermissionService.RequestPermissionResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PermissionServiceRequestPermissionResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            PermissionServiceRequestPermissionResponseParams _response = new PermissionServiceRequestPermissionResponseParams();
            _response.status = status;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    REQUEST_PERMISSION_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class PermissionServiceRequestPermissionsParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 32;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(32, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int[] permission;
        public String origin;
        public boolean userGesture;
    
        private PermissionServiceRequestPermissionsParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PermissionServiceRequestPermissionsParams() {
            this(0);
        }
    
        public static PermissionServiceRequestPermissionsParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PermissionServiceRequestPermissionsParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PermissionServiceRequestPermissionsParams result = new PermissionServiceRequestPermissionsParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.permission = decoder0.readInts(8, org.chromium.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.origin = decoder0.readString(16, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.userGesture = decoder0.readBoolean(24, 0);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(permission, 8, org.chromium.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            encoder0.encode(origin, 16, false);
            encoder0.encode(userGesture, 24, 0);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PermissionServiceRequestPermissionsParams other = (PermissionServiceRequestPermissionsParams) object;
            if (!java.util.Arrays.equals(this.permission, other.permission))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.origin, other.origin))
                return false;
            if (this.userGesture != other.userGesture)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + java.util.Arrays.hashCode(permission);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(origin);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(userGesture);
            return result;
        }
    }

    static final class PermissionServiceRequestPermissionsResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int[] statuses;
    
        private PermissionServiceRequestPermissionsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PermissionServiceRequestPermissionsResponseParams() {
            this(0);
        }
    
        public static PermissionServiceRequestPermissionsResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PermissionServiceRequestPermissionsResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PermissionServiceRequestPermissionsResponseParams result = new PermissionServiceRequestPermissionsResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.statuses = decoder0.readInts(8, org.chromium.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(statuses, 8, org.chromium.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PermissionServiceRequestPermissionsResponseParams other = (PermissionServiceRequestPermissionsResponseParams) object;
            if (!java.util.Arrays.equals(this.statuses, other.statuses))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + java.util.Arrays.hashCode(statuses);
            return result;
        }
    }

    static class PermissionServiceRequestPermissionsResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final PermissionService.RequestPermissionsResponse mCallback;

        PermissionServiceRequestPermissionsResponseParamsForwardToCallback(PermissionService.RequestPermissionsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(REQUEST_PERMISSIONS_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                PermissionServiceRequestPermissionsResponseParams response = PermissionServiceRequestPermissionsResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.statuses);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PermissionServiceRequestPermissionsResponseParamsProxyToResponder implements PermissionService.RequestPermissionsResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PermissionServiceRequestPermissionsResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(int[] statuses) {
            PermissionServiceRequestPermissionsResponseParams _response = new PermissionServiceRequestPermissionsResponseParams();
            _response.statuses = statuses;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    REQUEST_PERMISSIONS_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class PermissionServiceRevokePermissionParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int permission;
        public String origin;
    
        private PermissionServiceRevokePermissionParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PermissionServiceRevokePermissionParams() {
            this(0);
        }
    
        public static PermissionServiceRevokePermissionParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PermissionServiceRevokePermissionParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PermissionServiceRevokePermissionParams result = new PermissionServiceRevokePermissionParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.permission = decoder0.readInt(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.origin = decoder0.readString(16, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(permission, 8);
            encoder0.encode(origin, 16, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PermissionServiceRevokePermissionParams other = (PermissionServiceRevokePermissionParams) object;
            if (this.permission != other.permission)
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.origin, other.origin))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(permission);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(origin);
            return result;
        }
    }

    static final class PermissionServiceRevokePermissionResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int status;
    
        private PermissionServiceRevokePermissionResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PermissionServiceRevokePermissionResponseParams() {
            this(0);
        }
    
        public static PermissionServiceRevokePermissionResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PermissionServiceRevokePermissionResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PermissionServiceRevokePermissionResponseParams result = new PermissionServiceRevokePermissionResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.status = decoder0.readInt(8);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(status, 8);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PermissionServiceRevokePermissionResponseParams other = (PermissionServiceRevokePermissionResponseParams) object;
            if (this.status != other.status)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(status);
            return result;
        }
    }

    static class PermissionServiceRevokePermissionResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final PermissionService.RevokePermissionResponse mCallback;

        PermissionServiceRevokePermissionResponseParamsForwardToCallback(PermissionService.RevokePermissionResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(REVOKE_PERMISSION_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                PermissionServiceRevokePermissionResponseParams response = PermissionServiceRevokePermissionResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.status);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PermissionServiceRevokePermissionResponseParamsProxyToResponder implements PermissionService.RevokePermissionResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PermissionServiceRevokePermissionResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            PermissionServiceRevokePermissionResponseParams _response = new PermissionServiceRevokePermissionResponseParams();
            _response.status = status;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    REVOKE_PERMISSION_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class PermissionServiceGetNextPermissionChangeParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int permission;
        public String origin;
        public int lastKnownStatus;
    
        private PermissionServiceGetNextPermissionChangeParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PermissionServiceGetNextPermissionChangeParams() {
            this(0);
        }
    
        public static PermissionServiceGetNextPermissionChangeParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PermissionServiceGetNextPermissionChangeParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PermissionServiceGetNextPermissionChangeParams result = new PermissionServiceGetNextPermissionChangeParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.permission = decoder0.readInt(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.lastKnownStatus = decoder0.readInt(12);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.origin = decoder0.readString(16, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(permission, 8);
            encoder0.encode(lastKnownStatus, 12);
            encoder0.encode(origin, 16, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PermissionServiceGetNextPermissionChangeParams other = (PermissionServiceGetNextPermissionChangeParams) object;
            if (this.permission != other.permission)
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.origin, other.origin))
                return false;
            if (this.lastKnownStatus != other.lastKnownStatus)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(permission);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(origin);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(lastKnownStatus);
            return result;
        }
    }

    static final class PermissionServiceGetNextPermissionChangeResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int status;
    
        private PermissionServiceGetNextPermissionChangeResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public PermissionServiceGetNextPermissionChangeResponseParams() {
            this(0);
        }
    
        public static PermissionServiceGetNextPermissionChangeResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static PermissionServiceGetNextPermissionChangeResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            PermissionServiceGetNextPermissionChangeResponseParams result = new PermissionServiceGetNextPermissionChangeResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.status = decoder0.readInt(8);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(status, 8);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            PermissionServiceGetNextPermissionChangeResponseParams other = (PermissionServiceGetNextPermissionChangeResponseParams) object;
            if (this.status != other.status)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(status);
            return result;
        }
    }

    static class PermissionServiceGetNextPermissionChangeResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final PermissionService.GetNextPermissionChangeResponse mCallback;

        PermissionServiceGetNextPermissionChangeResponseParamsForwardToCallback(PermissionService.GetNextPermissionChangeResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_NEXT_PERMISSION_CHANGE_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                PermissionServiceGetNextPermissionChangeResponseParams response = PermissionServiceGetNextPermissionChangeResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.status);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PermissionServiceGetNextPermissionChangeResponseParamsProxyToResponder implements PermissionService.GetNextPermissionChangeResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PermissionServiceGetNextPermissionChangeResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer status) {
            PermissionServiceGetNextPermissionChangeResponseParams _response = new PermissionServiceGetNextPermissionChangeResponseParams();
            _response.status = status;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    GET_NEXT_PERMISSION_CHANGE_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

}

